#include "SDL.h"
#include "SDL_ttf.h"
#include <time.h>
#include <math.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "Button.h"
#include <string.h>
#include <math.h>

#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 960-40


/*
 Idées :
  - cube se décompose
  - Easter Egg : 42 difficile + clic dessus
  - cube piégé (noir)
  - Magasin
 */

TTF_Font *police;

SDL_Window *window;
SDL_Renderer *renderer;

int randomInt(int min, int max)
{
    return min + rand() % ((max - min + 1) == 0 ? 1 : (max - min + 1));
}

int isLight(int r, int g, int b)
{
    return (r>100 && g>100 && b>100);
}
int isBeautifulColor(int r,int g,int b)
{
    return (abs(r-g)<100 && abs(r-b)<100 && abs(b-g)<100 && isLight(r, g, b));
}

void makeRect(SDL_Renderer *renderer, Uint8 r, Uint8 g, Uint8 b, SDL_Rect rect)
{
    SDL_SetRenderDrawColor(renderer, r, g, b, 255);
    SDL_RenderFillRect(renderer, &rect);
}

Uint32 myMapRGB(int r, int g, int b)
{
    return (r*256 + g*65536 + b*16777216);
}

struct Vector
{
    int x;
    float y;
};

int max(int a, int b)
{
	return (a>b)?a:b;
}

char* itos(const int nb)
{
    char DEC[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}; //Je prépare une chaîne de caractères avec tous les nombres sous forme de caractères dedans.
    char nbTxt[10];
    int i = 0, j = 0, cpt = 0, reste = 0; //reste ira de 0 à 10
    char chaine[11]; //Un int contient dix chiffres maximum plus un octet de signe cela fait 11 char.
    int quotient = nb;
    
    quotient = abs(quotient); //Je ne travaille pour le moment qu'avec des nombres positifs.
    while (quotient != 0) //Ici j'inscrit les chiffres les uns après les autres mais en commençant par la droite.
    {
        reste = quotient % 10;
        quotient = (int) quotient / 10;
        chaine[cpt] = DEC[reste];
        cpt++;
    }
    if (nb < 0) //Si l'entier reçu est négatif alors je rajoute le moins. (à droite de ma chaîne)
    {
        chaine[cpt]='-';
        cpt++;
    }
    for(i = 0, j = cpt - 1 ; i < cpt ; i++, j--) //Enfin je met la chaîne de caractères dans le bon sens.
        nbTxt[j] = chaine[i];
    nbTxt[cpt] = 0; //Je rajoute le caractère de fin de chaîne,
    
    return nbTxt; //et je renvoie tout ça.
}

static void fgChangeWhite (Button* bouton)
{
	bouton->changeFg((SDL_Color){255, 255,255});
}
static void fgChangeGrey (Button* bouton)
{
	bouton->changeFg((SDL_Color){207,207,207});
}

typedef struct Difficulte
{
	int vitesse;
	int temps;
	int taillemin;
	int taillemax;
}Difficulte;

Difficulte mode;

static int cmp (void const *a, void const *b)
{
	int* pa = (int*)a;
	int* pb = (int*)b;
	return *pb - *pa;
}

SDL_Texture* RenderText_Blended(SDL_Renderer* renderer, TTF_Font* police, char* text, SDL_Color couleur, SDL_Rect* info)
{
    SDL_Texture *texture;
    SDL_Surface* surface;
    surface = TTF_RenderText_Blended(police, text, couleur);
    info->h = surface->h;
    info->w = surface->w;
    texture = SDL_CreateTextureFromSurface(renderer, surface);
	SDL_FreeSurface(surface);
    return texture;
}

void jouer(bool Entrainement)
{
    SDL_Event event;
    SDL_Rect positionRect;
    SDL_Color couleurRect;
    SDL_Rect infoTexte, infoScore;
	
	Button* quitter = new Button("quitter", police, (SDL_Rect){SCREEN_WIDTH - 200, 20}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	
    struct SDL_Texture* texte;
    struct SDL_Texture* scoreText;
	struct Vector move;
	
	bool appFg = true;
	int saveTime;
    int score = 0;
	
    positionRect.h = randomInt(mode.taillemin, mode.taillemax);
    positionRect.w = randomInt(mode.taillemin, mode.taillemax);
    positionRect.x = randomInt(0, SCREEN_WIDTH-positionRect.w);
    positionRect.y = randomInt(0, SCREEN_HEIGHT-positionRect.h);

    move.x = mode.vitesse;
    move.y = mode.vitesse;
    
    couleurRect.r = randomInt(0, 255);
    couleurRect.g = randomInt(0, 255);
    couleurRect.b = randomInt(0, 255);
    
    int framerate = SDL_GetTicks();
    int finalTime = (Entrainement) ? SDL_GetTicks()+2000000000 : SDL_GetTicks()+mode.temps*1000;
    int timeleft = finalTime - SDL_GetTicks();
	
	quitter->render(false);
	quitter->onHover(fgChangeWhite);
	quitter->onDefault(fgChangeGrey);
	
    SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
    
    texte = RenderText_Blended(renderer, police, (char*)"Score : ", (SDL_Color){230,230,230}, &infoTexte);
    scoreText = RenderText_Blended(renderer, police, (char*)"0", (SDL_Color){230,230,230}, &infoScore);
	
    while (timeleft > 0) {
        timeleft = finalTime - SDL_GetTicks();
        
        
        while (SDL_PollEvent(&event)) {
            switch (event.type) {
				case SDL_FINGERDOWN:
					if (quitter->isHover(event.tfinger.x*SCREEN_WIDTH,event.tfinger.y*SCREEN_HEIGHT))
						timeleft = 0;
					break;
                case SDL_FINGERMOTION:
                    if(event.tfinger.x*SCREEN_WIDTH >= positionRect.x && event.tfinger.y*SCREEN_HEIGHT >= positionRect.y && event.tfinger.x*SCREEN_WIDTH <= positionRect.x + positionRect.w && event.tfinger.y*SCREEN_HEIGHT <= positionRect.y + positionRect.h)
                    {
                        positionRect.h = randomInt(mode.taillemin, mode.taillemax);
                        positionRect.w = randomInt(mode.taillemin, mode.taillemax);
                        positionRect.x = randomInt(0, SCREEN_WIDTH-positionRect.w);
                        positionRect.y = randomInt(0, SCREEN_HEIGHT-positionRect.h);
                        
                        do {
                            couleurRect.r = randomInt(0, 255);
                            couleurRect.g = randomInt(0, 255);
                            couleurRect.b = randomInt(0, 255);
                        } while (!isBeautifulColor(couleurRect.r, couleurRect.g, couleurRect.b));
                        
                        move.x = randomInt((int)(mode.vitesse/2 + 0.5), mode.vitesse);
                        if (randomInt(0, 1))
                            move.x *= -1;
                        score++;
                        move.y = 0;
                        scoreText = RenderText_Blended(renderer, police, itos(score), (SDL_Color){230,230,230}, &infoScore);
						
						
                    }
                    break;
				case SDL_APP_WILLENTERBACKGROUND:
					saveTime = SDL_GetTicks();
					SDL_Delay(100);
					while (!appFg)
					{
						SDL_WaitEvent(&event);
						if(event.type == SDL_APP_WILLENTERFOREGROUND)
							appFg = true;
					}
					finalTime += SDL_GetTicks() - saveTime;
				break;
            }
        }
        
        if (positionRect.x + positionRect.w >= SCREEN_WIDTH || positionRect.x <= 0)
            move.x *= -1;
        if (positionRect.y + positionRect.h >= SCREEN_HEIGHT)
			move.y -= randomInt(move.y + (int)(move.y - move.y/5) + 5, move.y + (int)(move.y - move.y/5) + 10);
		if (positionRect.y <= 0)
            move.y = 1;
		move.y += 0.2;
		
        positionRect.x += move.x;
        positionRect.y += (int)move.y+0.5;
		printf("%d ms\n",(SDL_GetTicks() - framerate));
        SDL_Delay(max(10 - (SDL_GetTicks() - framerate), 0));
		
        framerate = SDL_GetTicks();
        
        infoTexte.x = 20;
        infoTexte.y = 20;
        
        infoScore.x = 20 + infoTexte.w;
        infoScore.y = 20;
        
		makeRect(renderer, couleurRect.r, couleurRect.g, couleurRect.b, positionRect);
		
        SDL_RenderCopy(renderer, scoreText, NULL, &infoScore);
        
        SDL_RenderCopy(renderer, texte, NULL, &infoTexte);
		quitter->Draw();
		
        if(!Entrainement)
			makeRect(renderer, 150, 150, 150, (SDL_Rect){SCREEN_WIDTH/2-((int)timeleft/(mode.temps*1000/SCREEN_WIDTH))/2,10,((int)timeleft/(mode.temps*1000/SCREEN_WIDTH)),4});
        
        SDL_RenderPresent(renderer);
		
        makeRect(renderer, 40, 40, 40, positionRect);
        makeRect(renderer, 40, 40, 40, (SDL_Rect){0,10,SCREEN_WIDTH,4});
        makeRect(renderer, 40, 40, 40, infoScore);
		
    }
	
	makeRect(renderer, 40, 40, 40, infoTexte);
	
    quitter->changeBg((SDL_Color){40, 40, 40});
	quitter->changeFg((SDL_Color){40, 40, 40});
	quitter->render(false);
	quitter->Draw();
	
    infoTexte.y = 300;
    infoTexte.x = 300 - infoTexte.w/2;
    
    infoScore.y = 300;
    infoScore.x = 300 + infoTexte.w/2;
    
    SDL_RenderCopy(renderer, texte, NULL, &infoTexte);
    SDL_RenderCopy(renderer, scoreText, NULL, &infoScore);

    SDL_RenderPresent(renderer);
    if(!Entrainement)
	{
		FILE* fichier = NULL;
		if (mode.temps == 45)
			fichier = fopen("scoref.sc", "r+");
		if (mode.temps == 30)
			fichier = fopen("scorem.sc", "r+");
		if (mode.temps == 15)
			fichier = fopen("scored.sc", "r+");
		if (mode.temps == 10)
			fichier = fopen("scoreh.sc", "r+");
	
		int buffer[6];
		fseek(fichier, 0, SEEK_SET);
		for (int i = 0; i<= 4; i++)
		{
			fscanf(fichier,"%d",&buffer[i]);
			fseek(fichier, 1, SEEK_CUR);
		}
		buffer[5] = score;
		qsort(buffer, 6, sizeof(int), cmp);
	
		if (mode.temps == 45)
			fichier = freopen("scoref.sc", "w+", fichier);
		if (mode.temps == 30)
			fichier = freopen("scorem.sc", "w+", fichier);
		if (mode.temps == 15)
			fichier = freopen("scored.sc", "w+", fichier);
		if (mode.temps == 10)
			fichier = freopen("scoreh.sc", "w+", fichier);
	
		for	(int i = 0; i<=4; i++)
		{
			fprintf(fichier, "%d",buffer[i]);
			fseek(fichier, 1, SEEK_CUR);
		}
		fclose(fichier);
	}
	
	SDL_Delay(3000);
	
	SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
	SDL_RenderPresent(renderer);
}

void chooseDiff()
{
	bool done = false;
	
	Button* Facile = new Button("Facile", police, (SDL_Rect){SCREEN_WIDTH/2, 200}, (SDL_Color){207, 207, 207},(SDL_Color){39, 156, 0});
	Button* Moyen = new Button("Moyen", police, (SDL_Rect){SCREEN_WIDTH/2, 300}, (SDL_Color){207, 207, 207},(SDL_Color){255, 100, 30});
	Button* Difficile = new Button("Difficile", police, (SDL_Rect){SCREEN_WIDTH/2, 400}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	Button* Hardcore = new Button("Hardcore", police, (SDL_Rect){SCREEN_WIDTH/2,500},(SDL_Color){207, 207, 207},(SDL_Color){176,33,14});
	
	Facile->render(true);
	Facile->onHover(fgChangeWhite);
	Facile->onDefault(fgChangeGrey);
	
	Moyen->render(true);
	Moyen->onHover(fgChangeWhite);
	Moyen->onDefault(fgChangeGrey);
	
	Difficile->render(true);
	Difficile->onHover(fgChangeWhite);
	Difficile->onDefault(fgChangeGrey);
	
	Hardcore->render(true);
	Hardcore->onHover(fgChangeWhite);
	Hardcore->onDefault(fgChangeGrey);
	
	SDL_Event e;
	
	SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
	
	Facile->Draw();
	Moyen->Draw();
	Difficile->Draw();
	Hardcore->Draw();
	
	SDL_RenderPresent(renderer);
	
	while (!done)
    {
		SDL_WaitEvent(&e);
		Facile->sendEvent(e);
		Moyen->sendEvent(e);
		Difficile->sendEvent(e);
		Hardcore->sendEvent(e);
		
		if (e.type == SDL_FINGERUP)
		{
			if(Facile->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				mode.temps = 45;
				mode.vitesse = 3;
				mode.taillemin = 100;
				mode.taillemax = 140;
				done = true;
			}
			
			if(Moyen->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				mode.temps = 30;
				mode.vitesse = 4;
				mode.taillemin = 70;
				mode.taillemax = 110;
				done = true;
			}
			
			if(Difficile->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				mode.temps = 15;
				mode.vitesse = 5;
				mode.taillemin = 40;
				mode.taillemax = 70;
				done = true;
			}
			
			if(Hardcore->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				mode.temps = 10;
				mode.vitesse = 7;
				mode.taillemin = 40;
				mode.taillemax = 60;
				done = true;
			}
		}
        
		Facile->render(false);
		Moyen->render(false);
		Difficile->render(false);
		Hardcore->render(false);
		
        Facile->Draw();
		Moyen->Draw();
		Difficile->Draw();
		Hardcore->Draw();
		
        SDL_RenderPresent(renderer);
    }
	
	SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
	SDL_RenderPresent(renderer);
	delete Facile;
	delete Moyen;
	delete Difficile;
	delete Hardcore;
	
}
char* mystrcat(const char* dest, int nb)
{
	char* end;
	char* tampon;
	tampon = (char *) malloc(100 * sizeof(char));
	end = (char *) malloc(100 * sizeof(char));
	sprintf(tampon, "%d", nb);
	strcat(end, dest);
	strcat(end, tampon);
	return end;
}
void seeHigh()
{
	FILE* fscoreh;
	int scoreh[5];
	fscoreh = fopen("scoreh.sc", "r+");
	for (int i = 0; i<= 4; i++)
	{
		fscanf(fscoreh, "%d", &scoreh[i]);
		fseek(fscoreh, 1, SEEK_CUR);
	}
	fclose(fscoreh);
	
	FILE* fscored;
	int scored[5];
	fscored = fopen("scored.sc", "r+");
	for (int i = 0; i<= 4; i++)
	{
		fscanf(fscored, "%d", &scored[i]);
		fseek(fscored, 1, SEEK_CUR);
	}
	fclose(fscored);
	
	FILE* fscorem;
	int scorem[5];
	fscorem = fopen("scorem.sc", "r+");
	for (int i = 0; i<= 4; i++)
	{
		fscanf(fscorem, "%d", &scorem[i]);
		fseek(fscorem, 1, SEEK_CUR);
	}
	fclose(fscorem);
	
	FILE* fscoref;
	int scoref[5];
	fscoref = fopen("scoref.sc", "r+");
	for (int i = 0; i<= 4; i++) {
		fscanf(fscoref, "%d", &scoref[i]);
		fseek(fscoref, 1, SEEK_CUR);
	}
	fclose(fscoref);
	
	int mode = 0;
	
	Button* change = new Button((char*)"Facile", police, (SDL_Rect){SCREEN_WIDTH/2, 100}, (SDL_Color){207, 207, 207},(SDL_Color){39, 156, 0});
	Button* score1 = new Button(mystrcat("1. ",scoref[0]), police, (SDL_Rect){SCREEN_WIDTH/2, 200},(SDL_Color){207, 207, 207},(SDL_Color){40, 40, 40});
	Button* score2 = new Button(mystrcat("2. ",scoref[1]), police, (SDL_Rect){SCREEN_WIDTH/2, 300},(SDL_Color){207, 207, 207},(SDL_Color){40, 40, 40});
	Button* score3 = new Button(mystrcat("3. ",scoref[2]), police, (SDL_Rect){SCREEN_WIDTH/2, 400},(SDL_Color){207, 207, 207},(SDL_Color){40, 40, 40});
	Button* score4 = new Button(mystrcat("4. ",scoref[3]), police, (SDL_Rect){SCREEN_WIDTH/2, 500},(SDL_Color){207, 207, 207},(SDL_Color){40, 40, 40});
	Button* score5 = new Button(mystrcat("5. ",scoref[4]), police, (SDL_Rect){SCREEN_WIDTH/2, 600},(SDL_Color){207, 207, 207},(SDL_Color){40, 40, 40});
	Button* quitter = new Button((char*)"quitter", police, (SDL_Rect){SCREEN_WIDTH - 200, 20}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	
	quitter->render(false);
	quitter->onHover(fgChangeWhite);
	quitter->onDefault(fgChangeGrey);
	
	change->render(true);
	quitter->onHover(fgChangeWhite);
	quitter->onDefault(fgChangeGrey);
	
	score1->render(true);
	
	score2->render(true);
	
	score3->render(true);
	
	score4->render(true);
	
	score5->render(true);
	
	SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
	
	change->Draw();
	score1->Draw();
	score2->Draw();
	score3->Draw();
	score4->Draw();
	score5->Draw();
	quitter->Draw();
	
	SDL_RenderPresent(renderer);
	SDL_Event e;
	bool done = false;
	while (!done)
	{
		SDL_WaitEvent(&e);
		if (e.type == SDL_QUIT) {
			SDL_Quit();
		}
		quitter->sendEvent(e);
		switch (e.type)
		{
			case SDL_FINGERDOWN:
				if(change->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
					change->changeFg((SDL_Color){255, 255,255});
				else
					change->changeFg((SDL_Color){207, 207, 207});
			
				change->render(false);
				break;
			case SDL_FINGERUP:
				if(quitter->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
					done = true;
				
				if(change->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
				{
					++mode;
					if(mode%4 == 0)
					{
						score1->changeText(mystrcat("1. ", scoref[0]));
						score2->changeText(mystrcat("2. ", scoref[1]));
						score3->changeText(mystrcat("3. ", scoref[2]));
						score4->changeText(mystrcat("4. ", scoref[3]));
						score5->changeText(mystrcat("5. ", scoref[4]));
						
						change->changeText("Facile");
						change->changeBg((SDL_Color){39, 156, 0});
					}
					if(mode%4 == 1)
					{
						score1->changeText(mystrcat("1. ", scorem[0]));
						score2->changeText(mystrcat("2. ", scorem[1]));
						score3->changeText(mystrcat("3. ", scorem[2]));
						score4->changeText(mystrcat("4. ", scorem[3]));
						score5->changeText(mystrcat("5. ", scorem[4]));
						
						change->changeText("Moyen");
						change->changeBg((SDL_Color){255, 100, 30});
					}
					if(mode%4 == 2)
					{
						score1->changeText(mystrcat("1. ", scored[0]));
						score2->changeText(mystrcat("2. ", scored[1]));
						score3->changeText(mystrcat("3. ", scored[2]));
						score4->changeText(mystrcat("4. ", scored[3]));
						score5->changeText(mystrcat("5. ", scored[4]));
						
						change->changeText("Difficile");
						change->changeBg((SDL_Color){125, 124, 124});
					}
					if(mode%4 == 3)
					{
						score1->changeText(mystrcat("1. ", scoreh[0]));
						score2->changeText(mystrcat("2. ", scoreh[1]));
						score3->changeText(mystrcat("3. ", scoreh[2]));
						score4->changeText(mystrcat("4. ", scoreh[3]));
						score5->changeText(mystrcat("5. ", scoreh[4]));
						
						change->changeText("Hardcore");
						change->changeBg((SDL_Color){176,33,14});
					}
					
					change->setPosition(SCREEN_WIDTH/2, 100);
					score1->setPosition(SCREEN_WIDTH/2, 200);
					score2->setPosition(SCREEN_WIDTH/2, 300);
					score3->setPosition(SCREEN_WIDTH/2, 400);
					score4->setPosition(SCREEN_WIDTH/2, 500);
					score5->setPosition(SCREEN_WIDTH/2, 600);
					
					change->render(true);
					
					score1->render(true);
					
					score2->render(true);
					
					score3->render(true);
					
					score4->render(true);
					
					score5->render(true);
				}
				else
					change->changeFg((SDL_Color){207, 207, 207});
				change->render(false);
				break;
		}
		quitter->render(false);
		
		SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
		SDL_RenderClear(renderer);
		
		change->Draw();
		score1->Draw();
		score2->Draw();
		score3->Draw();
		score4->Draw();
		score5->Draw();
		quitter->Draw();
        SDL_RenderPresent(renderer);
    }
	delete quitter;
	delete score1;
	delete score2;
	delete score3;
	delete score4;
	delete score5;
	
	SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
	SDL_RenderClear(renderer);
}

void menu()
{
    Button* Jouer = new Button("Jouer", police, (SDL_Rect){SCREEN_WIDTH/2,200},(SDL_Color){227, 227, 227},(SDL_Color){255, 175, 10});
    Button* Entrainement = new Button("Entrainement", police, (SDL_Rect){SCREEN_WIDTH/2, 300}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	Button* Difficulte = new Button("Difficulte", police, (SDL_Rect){SCREEN_WIDTH/2, 400}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	Button* Highscore = new Button("Highscore",police,(SDL_Rect){SCREEN_WIDTH/2, 500}, (SDL_Color){207, 207, 207},(SDL_Color){125, 124, 124});
	
	Jouer->render(true);
	Jouer->onHover(fgChangeWhite);
	Jouer->onDefault(fgChangeGrey);
	
	Entrainement->render(true);
	Entrainement->onHover(fgChangeWhite);
	Entrainement->onDefault(fgChangeGrey);
	
	Difficulte->render(true);
	Difficulte->onHover(fgChangeWhite);
	Difficulte->onDefault(fgChangeGrey);
	
	Highscore->render(true);
	Highscore->onHover(fgChangeWhite);
	Highscore->onDefault(fgChangeGrey);
	
    SDL_Event e;
    
    SDL_SetRenderDrawColor(renderer, 40,40,40, 0);
    SDL_RenderClear(renderer);
	
	Jouer->Draw();
	Entrainement->Draw();
	Difficulte->Draw();
	Highscore->Draw();
	
	SDL_RenderPresent(renderer);
    
    while (true)
    {
		SDL_WaitEvent(&e);
		if (e.type == SDL_QUIT) {
			SDL_Quit();
		}
		Jouer->sendEvent(e);
		Entrainement->sendEvent(e);
		Difficulte->sendEvent(e);
		Highscore->sendEvent(e);
		
		if (e.type == SDL_FINGERUP)
		{
			if(Jouer->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				jouer(false);
				Jouer->changeFg((SDL_Color){227, 227, 227});
			}
			if(Entrainement->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				jouer(true);
				Entrainement->changeFg((SDL_Color){207, 207, 207});
			}
			if(Difficulte->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				chooseDiff();
				Difficulte->changeFg((SDL_Color){207, 207, 207});
			}
			if(Highscore->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
			{
				seeHigh();
				Highscore->changeFg((SDL_Color){207, 207, 207});
			}
		}
		
        Jouer->render(false);
		Entrainement->render(false);
		Difficulte->render(false);
		Highscore->render(false);
		
        Jouer->Draw();
		Entrainement->Draw();
		Difficulte->Draw();
		Highscore->Draw();
        SDL_RenderPresent(renderer);
    }
	
}

int main(int argc, char *argv[])
{
    if (SDL_Init(SDL_INIT_VIDEO) < 0) {
        printf("Could not initialize SDL\n");
        return 1;
    }
    
    TTF_Init();
    
    police = TTF_OpenFont("visitor1.ttf", 40);
    
    srand(time(NULL));
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    window = SDL_CreateWindow(NULL, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, SDL_WINDOW_OPENGL);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    renderer = SDL_CreateRenderer(window, -1, 0);
	
	mode.temps = 45;
	mode.vitesse = 2;
	mode.taillemin = 70;
	mode.taillemax = 110;
	
    menu();

    /* shutdown SDL */
    TTF_CloseFont(police);
    TTF_Quit();
    SDL_Quit();

    return 0;
}
